/* 
 * MTKCPU:  A MTK plugin to monitor CPU usage.
 * Copyright (C) 2002-2005 Mike Piatek-Jimenez, Gaucho Software
 * You can view the complete license in the LICENSE file in the root
 * of the source tree.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

//
//  GSCPUMiner.h
//

#import <Foundation/Foundation.h>
#import "GSDataSet.h"

@interface GSCPUMiner : NSObject {
@private
    int							numSamples;
    int							numCPUs;
	bool						calculateUptime;
	bool						calculateLoadAverage;

    int							*fastValues;
    NSMutableArray              *userValues;
    NSMutableArray              *systemValues;
    NSMutableArray              *niceValues;
    float						*immediateUser;
    float						*immediateSystem;
    float						*immediateNice;
    float                       *immediateTotal;
    float						currentLoadAverage;
    int                         uptimeDays;
    int                         uptimeHours;
    int                         uptimeMinutes;
    int                         uptimeSeconds;

    processor_cpu_load_info_t   *lastSlowCPUInfo;
    processor_cpu_load_info_t   *lastFastCPUInfo;
    
    host_name_port_t			host;
    host_basic_info_data_t		hostInfo;
}

#pragma mark Data Update Methods
- (void)initNumCPUs;
- (void)tick;
- (void)quickTick;
- (int)mineCPUUsageForCPUs:(processor_cpu_load_info_t *)lastCPUInfo count:(int)count;
- (void)mineLoadAverage;
- (void)mineCurrentUptime;

#pragma mark Information Retrieval
- (int)numberOfCPUs;
- (float *)currentTotalUsage;
- (float *)currentUserUsage;
- (float *)currentSystemUsage;
- (float *)currentNiceUsage;
- (int *)fastValues;
- (float)currentLoadAverage;
- (int)uptimeDays;
- (int)uptimeHours;
- (int)uptimeMinutes;
- (int)uptimeSeconds;
- (NSArray *)dataForCPU:(int)cpuNumber;

#pragma mark Class Configuration
- (void)setDataSize:(int)newNumSamples;
- (void)shouldCalculateUptime:(bool)yesNo;
- (void)shouldCalculateLoadAverage:(bool)yesNo;

@end
